<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" 
    x-data="{ darkMode: localStorage.getItem('theme') === 'dark' }" 
    x-init="$watch('darkMode', value => localStorage.setItem('theme', value ? 'dark' : 'light'))" 
    :class="{ 'dark': darkMode }" x-cloak>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo e($title ?? 'CMS'); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="dark:bg-blue-950 dark:text-white h-screen bg-white text-black transition-all duration-300 ease-linear">

    <div class="grid grid-cols-12 space-x0-2 divide-x divide-slate-200">
        <nav>
            <ul>
                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li wire:key='<?php echo e($page->id); ?>'><a href="/admin/<?php echo e($page->slug); ?>"><?php echo e($page->title); ?></a></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </nav>
        <a href="/admin" wire:navigate>Admin Dashboard</a>
    </div>
    <div>
        <?php echo e($slot); ?>

    </div>
</body>

</html>
<?php /**PATH D:\Learning\Laravel\CMS\resources\views/components/layouts/app.blade.php ENDPATH**/ ?>