<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" 
    x-data="{ darkMode: localStorage.getItem('theme') === 'dark' }" 
    x-init="$watch('darkMode', value => localStorage.setItem('theme', value ? 'dark' : 'light'))" 
    :class="{ 'dark': darkMode }" x-cloak>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>{{ $title ?? 'CMS' }}</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="dark:bg-blue-950 dark:text-white h-screen bg-white text-black transition-all duration-300 ease-linear">

    <div class="grid grid-cols-12 space-x0-2 divide-x divide-slate-200">
        <nav>
            <ul>
                @foreach ($pages as $page)
                    <li wire:key='{{ $page->id }}'><a href="/admin/{{ $page->slug }}">{{ $page->title }}</a></li>
                @endforeach
            </ul>
        </nav>
        <a href="/admin" wire:navigate>Admin Dashboard</a>
    </div>
    <div>
        {{ $slot }}
    </div>
</body>

</html>
