<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Page>
 */
class PageFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'featured_image' => $this->faker->imageUrl(),
            'title' => $this->faker->word(),
            'slug' => $this->faker->slug(),
            'intro' => $this->faker->paragraph()
        ];
    }
}
