<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Article>
 */
class ArticleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => 1,
            'title' => $this->faker->word(),
            'slug' => $this->faker->slug(),
            'intro' => $this->faker->paragraph(),
            'content' => $this->faker->paragraph(),
            'featured_image' => $this->faker->imageUrl()
        ];
    }
}
