<?php

namespace App\Livewire\Frontend;

use App\Mail\ContactFormMail;
use App\Models\ContactForm;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\Layout;
use Livewire\Component;

class Contact extends Component
{

    #[Layout('layouts.admin')]

    public $name;
    public $email;
    public $phone;
    public $subject;
    public $message;

    public function send()
    {
        $validated = $this->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'subject' => 'required',
            'message' => 'required'
        ]);
        $contact = ContactForm::create($validated);
        Mail::to('admin@gmail.com')->queue(new ContactFormMail($contact));
        $this->reset();
        session()->flash('message', 'Form submitted successfully!');
    }

    public function render()
    {
        return view('livewire.frontend.contact');
    }
}
