<?php

namespace App\Http\Requests\Article;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateArticleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $articleId = $this->route('article')->id;
        return [
            'user_id' => 'sometimes|required',
            'title' => 'sometimes|required',
            'slug' => ['sometimes', 'required', Rule::unique('articles')->ignore($articleId)],
            'intro' => 'sometimes|required',
            'content' => 'sometimes|required',
            'featured_image' => 'nullable|image'
        ];
    }
}
