<?php 
get_header(); 
set_query_var('thumbnail', get_the_post_thumbnail_url());
// get_template_part("/inc/banner", null);
$terms = get_the_terms($post->ID, 'service');
$brand = get_the_terms($post->ID, 'partner');
$related_posts = [];
if ($terms && !is_wp_error($terms)) {
    $term_ids = wp_list_pluck($terms, 'term_id');
    $related_args = array(
        'post_type' => EDUCATIONAL_POST_TYPE,
        'posts_per_page' => 3,
        'orderby' => 'rand',
        'post__not_in' => array($post->ID),
    );
    $related_posts = new WP_Query($related_args);
}
?>

<section class="kh_container py-4 sm:py-8 lg:py-16 max-w-[1080px] mx-auto">
    <figure class="single-thumbnail w-full h-[30vh] lg:h-[40vh] mb-8">
        <img class="w-full h-full object-cover object-center" src="<?= get_the_post_thumbnail_url() ?>" alt="<?= get_the_title() ?>">
    </figure>
    <div class="mb-4 lg:mb-8">
        <h1 class="text-start text-lg md:text-xl lg:text-2xl xl:text-4xl font-bold mb-4"><?= get_the_title() ;?></h1>
    </div>
    <article class="text-justify"><?= the_content() ;?></article>
    <br><hr><br>
    <?php if ($related_posts->have_posts()) : ?>
        <div class="py-2 sm:py-4">
            <h1 class="text-xl lg:text-2xl text-center font-bold text-slate-800 tracking-wide mb-6">Related Posts</h1>
            <div class="grid grid-cols-3 gap-0 sm:gap-2 lg:gap-4">
                <?php while ($related_posts->have_posts()) : $related_posts->the_post(); ?>
                    <?php get_template_part('inc/related-educard', null); ?>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </div>
    <?php endif; ?>
</section>


<?php get_footer(); ?>