<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" x-data="{ darkMode: localStorage.getItem('theme') === 'dark' }" x-init="$watch('darkMode', value => localStorage.setItem('theme', value ? 'dark' : 'light'))" :class="{ 'dark': darkMode }" x-cloak>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo e($title ?? 'CMS'); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="h-screen overflow-hidden bg-white text-black transition-all duration-300 ease-linear dark:bg-blue-950 dark:text-white">

    
    <?php if(session()->has('message')): ?>
        <div x-data="{ show: false }" x-init="setTimeout(() => show = true, 500); setTimeout(() => show=false, 3000)" class="alert alert-success fixed bottom-8 w-auto transition-all duration-300 ease-linear"
            :class="show ? 'right-4' : '-right-full'">
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?>

    <div class="grid h-full grid-cols-12 divide-x">
        <div class="col-span-2 h-full text-center">
            <h1 class="py-8 pl-8 text-2xl font-bold text-red-600"><a href="/" wire:navigate>DShop</a></h1>
            <?php if (isset($component)) { $__componentOriginal21baf83cca9536a0054e5dafc5afc171 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal21baf83cca9536a0054e5dafc5afc171 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-nav','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin-nav'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal21baf83cca9536a0054e5dafc5afc171)): ?>
<?php $attributes = $__attributesOriginal21baf83cca9536a0054e5dafc5afc171; ?>
<?php unset($__attributesOriginal21baf83cca9536a0054e5dafc5afc171); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal21baf83cca9536a0054e5dafc5afc171)): ?>
<?php $component = $__componentOriginal21baf83cca9536a0054e5dafc5afc171; ?>
<?php unset($__componentOriginal21baf83cca9536a0054e5dafc5afc171); ?>
<?php endif; ?>
        </div>
        <div class="relative col-span-10 box-border h-full">
            <div class="absolute left-0 top-0 flex w-full items-center justify-between gap-4 border-b px-4 py-4 shadow dark:shadow-lg dark:shadow-black/30">
                <div class="text-2xl font-bold text-slate-700 dark:text-slate-200">
                    <?php echo e($title ?? ''); ?>

                </div>
                <div class="flex gap-4">
                    <?php if (isset($component)) { $__componentOriginald9964082a127bb2ff18ecf39a264a70b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald9964082a127bb2ff18ecf39a264a70b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.theme-controller','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('theme-controller'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald9964082a127bb2ff18ecf39a264a70b)): ?>
<?php $attributes = $__attributesOriginald9964082a127bb2ff18ecf39a264a70b; ?>
<?php unset($__attributesOriginald9964082a127bb2ff18ecf39a264a70b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald9964082a127bb2ff18ecf39a264a70b)): ?>
<?php $component = $__componentOriginald9964082a127bb2ff18ecf39a264a70b; ?>
<?php unset($__componentOriginald9964082a127bb2ff18ecf39a264a70b); ?>
<?php endif; ?>
                    <button>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                        </svg>
                    </button>

                </div>
            </div>
            <div class="relative h-full w-full overflow-y-auto pt-20">
                <?php echo e($slot); ?>

            </div>
        </div>
    </div>

</body>

</html>
<?php /**PATH D:\Learning\Laravel\CMS\resources\views/layouts/admin.blade.php ENDPATH**/ ?>