<div x-show="openModal">
    <div class="fixed left-0 top-0 flex h-full w-full items-center justify-center bg-black/20">
        <div class="box relative h-auto w-[400px] rounded bg-white px-8 py-4 shadow-lg"
        x-show="openModal"
        x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="opacity-0 scale-90"
        x-transition:enter-end="opacity-100 scale-100"
        x-transition:leave="transition ease-in duration-300"
        x-transition:leave-start="opacity-100 scale-100"
        x-transition:leave-end="opacity-0 scale-90"
        >
            <h1 class="mb-8 text-xl font-bold text-red-500">Create Role</h1>
            <div class="mb-8">
                @if (session()->has('message'))
                    <div class="alert alert-success">
                        {{ session('message') }}
                    </div>
                @endif

                <div>
                    <label for="roleName">Role Name</label>
                    <input class="form-input" type="text" wire:model="roleName" id="roleName" placeholder="Enter role name">
                </div>

                <div>
                    <label for="slug">Slug (Auto-Generated)</label>
                    <input class="form-input" type="text" wire:model="slug" id="slug" readonly>
                </div>

                <button wire:click="createRole" type="button" class="mt-8 rounded bg-green-500 px-6 py-2 font-semibold text-white">Add Role</button>
                <button @click="
            openModal = false;
            $nextTick(() => $wire.cancelAction())" type="button"
                    class="mt-8 rounded bg-gray-500 px-6 py-2 font-semibold text-white">Cancel</button>
            </div>
        </div>
    </div>
</div>
