<?php

namespace App\Providers;

use App\Models\Article;
use App\Models\Page;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {

        $pages = Cache::remember('articles', 10, function() {
            return Page::paginate();
        });
        View::share('pages', $pages);

        Schema::defaultStringLength(191);
    }
}
