<?php

namespace App\Livewire\Backend\User;

use App\Models\Article;
use App\Models\User;
use Livewire\Attributes\Title;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\Features\SupportPagination\WithoutUrlPagination;
use Livewire\WithPagination;

class UserList extends Component
{
    use WithPagination, WithoutUrlPagination;

    public $search = '';

    #[Title('Users')]
    #[Url(keep:true)]
    public function render()
    {
        $users = User::when($this->search !== '', function ($query) {
            return $query->search($this->search);
        })
        ->with([
            'roles:id,name',
            'articles:id,title,user_id'
        ])
        ->addSelect([
            'articles_count' => Article::selectRaw('count(*)')
                ->whereColumn('user_id', 'users.id')
        ])
        ->paginate(10);
    
    
        return view('livewire.backend.user.user-list', [
            'users' => $users
        ])->layout('layouts.admin');
    }

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function delete($id)
    {
        $user = User::findOrFail($id);
        $user->roles()->detach();
        $user->delete();

        session()->flash('message', 'User created successfully!');
        return $this->redirect(route('admin-users'), navigate: true);
    }
}
